\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 30))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-right = ##f
  %ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Fie numele Domnului"
  subtitle = "glasul 8"
  composer = "arm. după N. Lungu"
  %meter = "Allegretto"
  tagline=""
}

global = {
  \key f \major
  \time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- min.
  Fi -- e nu -- me -- le Dom -- nu -- lui bi -- ne -- cu -- vân -- tat,
  de a -- cum şi pâ -- nă-n veac.

  Fi -- e nu -- me -- le Dom -- nu -- lui bi -- ne -- cu -- vân -- tat, __
  de a -- cum şi pâ -- nă-n veac,
  de a -- cum şi pâ -- nă-n veac.
}

menWords = \womenWords

sopMusic = \relative c' {
  f2^\mf f \bar"||"
  \repeat volta 2 {
    f4^\p f a( g) a b c( d) c b
    a g a b c2 g4 a c b a g f2
  }
  \break
  f4^\mf f a( g) a b c( d) c c d c
  d4^\< e f2^\f~\! f4. h,8\rest
  c4^\mf c d^\accent c b a g2
  g4 g f e d2^\> e f\!^\fermata 
  \bar "|."
}

altMusic = \relative c' {
  f2 f
  f4 f a( g) a b c( d) c b a g f g a2
  e4 f a g f e f2
  f4 f a( g) a b c( d) c c b a b b a2~ a4. h8\rest
  a4 a b a g a g2 g4 g f e d2 e f
}

tenorMusic =  \relative c {
  f2 f
  f4 f f2 f4 g a( b) a g f g a b c2
  c4 c c c c b a2
  f4 f f2 f4 g a( b) a a b c c c c2( c4.) d,8\rest
  c'4 c d c b a g2 g4 g f e f2 g f
}

bassMusic = \relative c {
  f2 f
  f4 f f2 f4 g a( b) a g f c f f f2
  e4 f a g f c f2
  f4 f f2 f4 g a( b) a a b a b g f2~ f4. d8\rest
  f4 f b a g f g2 g4 g f e d2 c <f f,>
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \tenorMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 120
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}